unit fROR_MDIChild;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 9 $  $Modtime: 3/02/05 9:06a $
*       Site:           Hines OIFO
*       Developers:
*                                      
*
*       Description:    Custom MDI child form
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.0/Current/fROR_MDIChild.pas $
*
* $History: fROR_MDIChild.pas $
 * 
 * *****************  Version 9  *****************
 * User: Vhaishgavris Date: 3/02/05    Time: 11:54a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 8  *****************
 * User: Vhaishgavris Date: 3/01/05    Time: 4:54p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 7  *****************
 * User: Vhaishgavris Date: 9/30/04    Time: 11:35a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 6  *****************
 * User: Vhaishgavris Date: 9/24/04    Time: 11:24a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 5  *****************
 * User: Vhaishgavris Date: 8/20/04    Time: 12:29p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 4  *****************
 * User: Vhaishgavris Date: 8/05/04    Time: 4:32p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 3  *****************
 * User: Vhaishgavris Date: 8/02/04    Time: 12:59p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishgavris Date: 5/03/04    Time: 3:55p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 1  *****************
 * User: Vhaishgavris Date: 5/03/04    Time: 8:57a
 * Created in $/CCR v1.0/Current
*
================================================================================
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uROR_Contextor;

type
  TFormMDIChild = class(TForm)
  private
    fEditCount:  Integer;
    fPendingDFN: String;

  protected
    property EditCount: Integer read fEditCount;

  public
    constructor Create(anOwner: TComponent); override;

    procedure AfterConstruction; override;
    function  CanBePrinted: Boolean; virtual;
    procedure CCOWResumed; virtual;
    procedure CCOWSuspended; virtual;
    procedure ClosePatientForms; virtual;
    procedure EndPatientEdit; virtual;
    function  HasBeenModified: Boolean; virtual;
    function  PageSetup: Boolean; virtual;
    procedure PatientChangeCommit(aContextor: TCCRContextor); virtual;
    function  PatientChangePending(aPatientIEN: String): WideString; virtual;
    function  Print: Boolean; virtual;
    function  PrintPreview: Boolean; virtual;
    function  SaveAs: Boolean; virtual;
    procedure SelectPatient(aPatientIEN: String); virtual;
    procedure StartPatientEdit; virtual;

  published
    procedure ApplyOptions; virtual;

  end;

implementation
{$R *.dfm}

uses
  uROR_Common;

constructor TFormMDIChild.Create(anOwner: TComponent);
begin
  inherited;
  fEditCount  := 0;
  fPendingDFN := UndefinedPatientID;
end;

procedure TFormMDIChild.AfterConstruction;
begin
  inherited;
  ApplyOptions;
end;

procedure TFormMDIChild.ApplyOptions;
begin
end;

function TFormMDIChild.CanBePrinted: Boolean;
begin
  Result := False;
end;

procedure TFormMDIChild.CCOWResumed;
begin
end;

procedure TFormMDIChild.CCOWSuspended;
begin
end;

procedure TFormMDIChild.ClosePatientForms;
var
  i: Integer;
begin
  if fEditCount > 0 then
    begin
      for i:=1 to Screen.CustomFormCount do
        begin
          if Screen.CustomForms[i-1] is TFormMDIChild then
            Break;
          if fsModal in Screen.CustomForms[i-1].FormState then
            Screen.CustomForms[i-1].Close;
        end;
    end;
end;

procedure TFormMDIChild.EndPatientEdit;
begin
  if fEditCount > 0 then
    Dec(fEditCount);
  if (fEditCount = 0) and (fPendingDFN <> UndefinedPatientID) then
    begin
      SelectPatient(fPendingDFN);
      fPendingDFN := UndefinedPatientID;
    end;
end;

function TFormMDIChild.HasBeenModified: Boolean;
begin
  Result := False;
end;

function TFormMDIChild.PageSetup: Boolean;
begin
  Result := True;
end;

procedure TFormMDIChild.PatientChangeCommit(aContextor: TCCRContextor);
begin
  if aContextor.ForcedChange then
    ClosePatientForms;
  if fEditCount > 0 then
    fPendingDFN := aContextor.PatientDFN
  else
    SelectPatient(aContextor.PatientDFN);
end;

function TFormMDIChild.PatientChangePending(aPatientIEN: String): WideString;
begin
  if fEditCount > 0 then
    Result := 'You might lose unsaved registry patient data.'
  else
    Result := '';
end;

function TFormMDIChild.Print: Boolean;
begin
  Result := True;
end;

function TFormMDIChild.PrintPreview: Boolean;
begin
  Result := True;
end;

function TFormMDIChild.SaveAs: Boolean;
begin
  Result := True;
end;

procedure TFormMDIChild.SelectPatient(aPatientIEN: String);
begin
end;

procedure TFormMDIChild.StartPatientEdit;
begin
  if fEditCount = 0 then
    fPendingDFN := UndefinedPatientID;
  Inc(fEditCount);
end;

end.
